# -*- coding: utf-8 -*-
import pymongo
import warnings

from mpfs.metastorage.mongo import collection
from mpfs.metastorage.mongo.util import LazyDatabaseObject


class MPFSMongoDatabase(pymongo.database.Database):
    collection_class = collection.MPFSMongoCollection

    def __getattr__(self, name):
        return self.collection_class(self, name)

    def create_collection(self, name, options=None, **kwargs):
        opts = {"create": True}
        if options is not None:
            warnings.warn("the options argument to create_collection is "
                          "deprecated and will be removed. please use "
                          "kwargs instead.", DeprecationWarning)
            opts.update(options)
        opts.update(kwargs)

        if name in self.collection_names():
            raise pymongo.errors.CollectionInvalid("collection %s already exists" % name)

        return self.collection_class(self, name, **opts)

    def drop_collection(self, name_or_collection):
        name = name_or_collection
        if isinstance(name, self.collection_class):
            name = name.name

        if not isinstance(name, basestring):
            raise TypeError("name_or_collection must be an instance of "
                            "(Collection, str, unicode)")

        self.__connection._purge_index(self.__name, name)

        self.command("drop", unicode(name), allowable_errors=["ns not found"])

    def validate_collection(self, name_or_collection,
                            scandata=False, full=False):
        name = name_or_collection
        if isinstance(name, self.collection_class):
            name = name.name

        if not isinstance(name, basestring):
            raise TypeError("name_or_collection must be an instance of "
                            "(Collection, str, unicode)")

        result = self.command("validate", unicode(name),
                              scandata=scandata, full=full)

        valid = True
        # Pre 1.9 results
        if "result" in result:
            info = result["result"]
            if info.find("exception") != -1 or info.find("corrupt") != -1:
                raise pymongo.errors.CollectionInvalid("%s invalid: %s" % (name, info))
        # Sharded results
        elif "raw" in result:
            for repl, res in result["raw"].iteritems():
                if "result" in res:
                    info = res["result"]
                    if (info.find("exception") != -1 or
                            info.find("corrupt") != -1):
                        raise pymongo.errors.CollectionInvalid("%s invalid: %s" % (name, info))
                elif not res.get("valid", False):
                    valid = False
                    break
        # Post 1.9 non-sharded results.
        elif not result.get("valid", False):
            valid = False

        if not valid:
            raise pymongo.errors.CollectionInvalid("%s invalid: %r" % (name, result))

        return result


class MPFSMongoLazyDatabase(LazyDatabaseObject):
    attribute_class = collection.MPFSMongoLazyCollection
    connection = None
    name = None

    def __init__(self, connection, db_name, *args, **kwargs):
        super(MPFSMongoLazyDatabase, self).__init__(*args, **kwargs)
        self.connection = connection
        self.name = db_name

    def get_instance(self):
        if isinstance(self.connection, LazyDatabaseObject):
            self.connection = self.connection.get_actual()
        return self.connection[self.name]
