# -*- coding: utf-8 -*-
import pymongo
import sys
import time
import re
import traceback
import threading

from copy import deepcopy
from pymongo import message, helpers, pool

import mpfs.engine.process


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
requests_log = mpfs.engine.process.get_requests_log()

RE_SPLIT_PATH = re.compile('/')

RE_SOCKET_TIME = re.compile("^(.*socket_time: )(\d+\.\d+)(.*)$") 
RE_REQUEST_NUMBER = re.compile("^(.*\.)(\d+)(.*)$")

request_message = {'main': ''}
processing_time = {'main': 0}

original_unpack_response = deepcopy(helpers._unpack_response)


def __set_request_message__(msg):
    global request_message
    thread = threading.current_thread().getName()
    request_message[thread] = msg + '.0'


def __get_request_message__():
    global request_message
    thread = threading.current_thread().getName()

    try:
        nose, number, tail = RE_REQUEST_NUMBER.match(request_message.get(thread, '')).groups()
    except (AttributeError, ValueError):
        return request_message.get(thread, '')
    else:
        request_message[thread] = nose + str(int(number) + 1) + tail
        return request_message[thread]


def __set_processing_time__(t):
    global processing_time
    thread = threading.current_thread().getName()
    processing_time[thread] = t


def __get_processing_time__():
    global processing_time
    thread = threading.current_thread().getName()
    result = processing_time.get(thread, 0)
    processing_time[thread] = None
    return result


def log_request(f):
    def wrapper(*args, **kwargs):
        start = time.time()
        try:
            result = f(*args, **kwargs)
        except Exception, e:
            delta = time.time() - start
            msg = '%s %.3f' % (__get_request_message__(), delta)
            error = '%s: %s' % (e.__class__.__name__, e)
            requests_log.info('failed ' + msg)
            error_log.debug(error)
            error_log.error(traceback.format_exc())
            raise
        else:
            delta = time.time() - start
            if f.__name__ == '_send_message_with_response':
                __set_processing_time__(delta)
            else:
                msg = '%s %.3f' % (__get_request_message__(), delta)
                requests_log.info('completed ' + msg)
            return result
    return wrapper


def __unpack_response(response, *args, **kwargs):
    """Unpack a response from the database and log it.
    """
    result = original_unpack_response(response, *args, **kwargs)
    delta = __get_processing_time__()
    if delta is not None:
        request_message = __get_request_message__()
        if request_message:
            request_message += ' '
        msg = request_message + '%s %s %.3f' % (result.get('number_returned'), len(response), delta)
        requests_log.info('completed ' + msg)
    return result
pymongo.helpers._unpack_response = __unpack_response


class CustomPool(pool.Pool):
    """
    Сейчас не используется, может понадобиться к таску
    https://st.yandex-team.ru/CHEMODAN-22567
    """
    def get_socket(self, *args, **kwargs):
        global request_message
        thread = threading.current_thread().getName()
        start = time.time()
        result = pool.Pool.get_socket(self, *args, **kwargs)
        delta = time.time() - start
        try:
            nose, sock_time, tail = RE_SOCKET_TIME.match(request_message.get(thread, '')).groups()
        except (AttributeError, ValueError):
            request_message[thread] += " socket_time: %.3f" % delta
        else:
            request_message[thread] = nose + '%.3f' % (float(sock_time) + delta) + tail
        return result

