# -*- coding: utf-8 -*-


class PostgresError(Exception):
    pass


class ReadOnlyDatabaseError(PostgresError):
    pass


class ConnectionClosedError(PostgresError):
    pass


class QueryCanceledError(PostgresError):
    pass


class EofDetectedError(PostgresError):
    pass


class SetAutocommitError(PostgresError):
    pass


class ConnectionBasedSessionClosed(PostgresError):
    pass


class DatabaseConstraintError(PostgresError):
    def __str__(self):
        return self.message


class UniqueConstraintViolationError(DatabaseConstraintError):
    pass
