# -*- coding: utf-8 -*-


SQL_INSERT_UPLOAD_LOG_RECORD = """
INSERT INTO disk.source_ids (
    uid,
    source_id,
    storage_id,
    is_live_photo
)
VALUES (
    :uid,
    :source_id,
    :storage_id,
    :is_live_photo
)
"""

SQL_SET_LIVE_PHOTO_FLAG_TO_SOURCE_IDS = """
UPDATE disk.source_ids s
SET is_live_photo = TRUE
WHERE s.uid = :uid AND s.storage_id = :storage_id
"""

SQL_GET_ALL_SOURCE_IDS_MAPPED_FOR_HIDS = """
SELECT s.uid, s.storage_id, s.is_live_photo, s.source_id as source_id
FROM disk.source_ids s
WHERE s.uid = :uid AND s.storage_id IN :storage_ids
"""

SQL_GET_ALL_SOURCE_IDS_MAPPED_FOR_HIDS_WITH_IS_LIVE_PHOTO_FLAG = SQL_GET_ALL_SOURCE_IDS_MAPPED_FOR_HIDS + """
AND is_live_photo = :is_live_photo
"""

SQL_GET_ALL_SOURCE_IDS_MAPPED_FOR_IDS = """
SELECT s.uid, s.storage_id, s.is_live_photo, s.source_id as source_id
FROM disk.source_ids s
WHERE s.uid = :uid AND s.source_id = ANY( :source_ids )
"""

SQL_DOES_RECORD_EXIST_BY_UID_HID_BASE = """
SELECT 1 as "found"
FROM disk.source_ids
WHERE uid = :uid AND storage_id = :storage_id AND is_live_photo = :is_live_photo
LIMIT 1
"""

SQL_DOES_RECORD_EXIST_BY_UID_SOURCE_ID = """
SELECT 1 as "found"
FROM disk.source_ids
WHERE uid = :uid AND source_id = :source_id
LIMIT 1
"""

SQL_SOURCE_ID_COUNT_BY_UID = """
SELECT count(*) as c
FROM disk.source_ids
WHERE uid = :uid
"""

SQL_SOURCE_ID_DELETE_BY_UID = """
DELETE
FROM disk.source_ids
WHERE uid = :uid
"""

SQL_SOURCE_ID_GET_BY_UID = """
SELECT uid, storage_id, is_live_photo, source_id
FROM disk.source_ids
WHERE uid = :uid
"""

SQL_ADD_RECORD_TO_DELETION_LOG = """
INSERT INTO disk.deletion_log (
    uid,
    file_id,
    storage_id,
    is_live_photo,
    deletion_log_revision
)
VALUES (
    :uid,
    :file_id,
    :storage_id,
    :is_live_photo,
    now()
)
"""

SQL_GET_DELETION_RECORDS_SORTED_BY_REVISION = """
SELECT uid, file_id, storage_id, is_live_photo, deletion_log_revision, array_agg(s.source_id) AS source_ids
FROM (
    SELECT d.uid AS uid,
        d.file_id AS file_id,
        d.deletion_log_revision AS deletion_log_revision,
        d.storage_id AS storage_id,
        d.is_live_photo AS is_live_photo
    FROM disk.deletion_log d
    WHERE uid = :uid AND d.deletion_log_revision > :deletion_log_revision
    ORDER BY d.deletion_log_revision
    LIMIT :limit
) AS d
JOIN disk.source_ids s USING (uid, storage_id, is_live_photo)
GROUP BY (uid, file_id, storage_id, is_live_photo, deletion_log_revision)
ORDER BY deletion_log_revision
"""

SQL_DELETION_LOG_COUNT_BY_UID = """
SELECT count(*) as c
FROM disk.deletion_log
WHERE uid = :uid
"""

SQL_DELETION_LOG_DELETE_BY_UID = """
DELETE
FROM disk.deletion_log
WHERE uid = :uid
"""

SQL_DELETION_LOG_GET_BY_UID = """
SELECT uid, file_id, storage_id, is_live_photo, deletion_log_revision
FROM disk.deletion_log
WHERE uid = :uid
"""

SQL_IS_HID_PRESENTED_IN_DELETION_LOG = """
SELECT 1 as "found"
FROM disk.deletion_log
WHERE uid = :uid AND storage_id = :storage_id AND is_live_photo = :is_live_photo
LIMIT 1
"""