# -*- coding: utf-8 -*-

import time

from psycopg2.extras import LoggingConnection, LoggingCursor
from psycopg2.extensions import connection as _connection


def before_cursor_execute(conn, clauseelement, multiparams, params):
    conn.info.setdefault('query_start_time', []).append(time.time())


def receive_after_execute(conn, clauseelement, multiparams, params, result):
    total = time.time() - conn.info['query_start_time'].pop(-1)


class PostgresLoggingConnection(LoggingConnection):
    def _logtologger(self, msg, curs):
        credentials = self.dsn
        execution_time = float(int((time.time() - curs.timestamp) * 1000)) / 1000
        row_count = curs.rowcount
        query = msg.replace('\n', ' ') if msg else ''

        log_message = '%s "%s" %d %3f' % (credentials, query, row_count, execution_time)

        self._logobj.info(log_message)

    def cursor(self, name=None):
        self._check()
        if name is None:
            return _connection.cursor(self, cursor_factory=PostgresLoggingCursor)
        else:
            return _connection.cursor(self, name, cursor_factory=PostgresLoggingCursor)


class PostgresLoggingCursor(LoggingCursor):
    def execute(self, query, vars=None):
        self.timestamp = time.time()
        return LoggingCursor.execute(self, query, vars)

    def callproc(self, procname, vars=None):
        self.timestamp = time.time()
        return LoggingCursor.execute(self, procname, vars)
