# -*- coding: utf-8 -*-

from mpfs.config import settings
from mpfs.dao.session import Session
from mpfs.engine.process import get_error_log
from mpfs.metastorage.postgres.queries import (SQL_REMOVE_EXPIRED_ENTRIES_CHANGELOG,
                                               SQL_REMOVE_EXPIRED_ENTRIES_FILESYSTEM_LOCKS,
                                               SQL_REMOVE_EXPIRED_ENTRIES_OPERATIONS)
from mpfs.metastorage.postgres.services import Sharpei


error_log = get_error_log()
POSTGRES_TTL_DELETE_BATCH_SIZE = settings.postgres['ttl']['delete_batch_size']


def delete_expired_entries():
    queries = (
        SQL_REMOVE_EXPIRED_ENTRIES_CHANGELOG,
        SQL_REMOVE_EXPIRED_ENTRIES_FILESYSTEM_LOCKS,
        SQL_REMOVE_EXPIRED_ENTRIES_OPERATIONS
    )

    catch_exception = False
    for query in queries:
        for shard_id in Sharpei().get_all_shard_ids():
            session = Session.create_from_shard_id(shard_id)

            has_rows_to_delete = True
            try:
                while has_rows_to_delete:
                    result = session.execute(query, {
                        'batch_size': POSTGRES_TTL_DELETE_BATCH_SIZE
                    })
                    if result.rowcount < POSTGRES_TTL_DELETE_BATCH_SIZE:
                        has_rows_to_delete = False
            except Exception:
                error_log.exception('Caught exception during TTL clean up. Shard id: %s', shard_id)
                catch_exception = True

    if catch_exception:
        raise

