# -*- coding: utf-8 -*-
from mpfs.metastorage.postgres.queries import sql_template, sql_query

# version_links

SQL_VERSIONING_GET_VERSION_LINK_BY_FILE_ID = """
SELECT
    *
FROM
    disk.version_links
WHERE uid=:uid AND file_id=:file_id
ORDER BY date_created DESC
LIMIT 1
"""

SQL_VERSIONING_GET_VERSION_LINK_BY_PATH_HASH = """
SELECT
    *
FROM
    disk.version_links
WHERE uid=:uid AND disk_path_hash=:disk_path_hash
ORDER BY date_created DESC
LIMIT 1
"""

SQL_VERSIONING_DELETE_VERSION_LINK = """
DELETE FROM
    disk.version_links
WHERE uid=:uid AND id=:id
"""

SQL_VERSIONING_SAVE_VERSION_LINK = """
INSERT INTO disk.version_links (id, uid, file_id, date_created, disk_path, disk_path_hash)
VALUES (:id, :uid, :file_id, :date_created, :disk_path, :disk_path_hash)
ON CONFLICT (id) DO UPDATE SET
    uid=:uid,
    file_id=:file_id,
    date_created=:date_created,
    disk_path=:disk_path,
    disk_path_hash=:disk_path_hash
"""

# version_data

sql_template(
    'SELECT_VERSION_FIELDS_TEMPLATE',
    """
    SELECT
        v.id,
        v.uid,
        v.record_date_created,
        v.date_to_remove,
        v.version_link_id,
        v.parent_version_id,
        v.type,
        v.date_created,
        v.is_checkpoint,
        v.folded_counter,
        v.uid_created,
        v.platform_created,
        v.storage_id,
        v.date_exif,
        s.size,
        s.md5_sum,
        s.sha256_sum,
        s.stid,
        s.preview_stid,
        s.digest_stid,
        s.av_scan_status,
        s.video_data,
        s.width,
        s.height,
        s.angle
    FROM
        disk.version_data as v
        LEFT OUTER JOIN disk.storage_files as s USING (storage_id)
    """
)

SQL_VERSIONING_GET_CHECKPOINT_VERSIONS_WITH_BORDER = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.uid=:uid AND v.version_link_id=:version_link_id AND v.date_created < :date_created AND v.is_checkpoint
ORDER BY v.date_created DESC
LIMIT :limit
""")

SQL_VERSIONING_GET_ALL_VERSIONS_WITH_BORDER = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.uid=:uid AND v.version_link_id=:version_link_id AND v.date_created < :date_created
ORDER BY v.date_created DESC
LIMIT :limit
""")

SQL_VERSIONING_GET_CHECKPOINT_VERSIONS = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.uid=:uid AND v.version_link_id=:version_link_id AND v.is_checkpoint
ORDER BY v.date_created DESC
LIMIT :limit
""")

SQL_VERSIONING_GET_ALL_VERSIONS = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.uid=:uid AND v.version_link_id=:version_link_id
ORDER BY v.date_created DESC
LIMIT :limit
""")

SQL_VERSIONING_GET_ALL_VERSIONS_ASC = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.uid=:uid AND v.version_link_id=:version_link_id
ORDER BY v.date_created ASC
LIMIT :limit
OFFSET :offset
""")

SQL_VERSIONING_GET_VERSION_BY_ID = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.uid=:uid and v.id=:id
""")

SQL_VERSIONING_GET_EXPIRED_VERSIONS = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE v.date_to_remove <= :date_to_remove
LIMIT :limit
""")

SQL_VERSIONING_SET_CHECKPOINT = """
UPDATE
    disk.version_data
SET is_checkpoint=:is_checkpoint
WHERE uid=:uid AND id=:id
"""

SQL_VERSIONING_DELETE_VERSIONS = """
DELETE FROM
    disk.version_data
WHERE id IN :ids
"""

SQL_VERSIONING_SAVE_VERSION = """
INSERT INTO disk.version_data (
    id,
    version_link_id,
    parent_version_id,
    type,
    uid,
    date_created,
    is_checkpoint,
    folded_counter,
    uid_created,
    platform_created,
    storage_id,
    date_exif,
    date_to_remove
)
VALUES (
    :id,
    :version_link_id,
    :parent_version_id,
    :type,
    :uid,
    :date_created,
    :is_checkpoint,
    :folded_counter,
    :uid_created,
    :platform_created,
    :storage_id,
    :date_exif,
    :date_to_remove
)
ON CONFLICT (id) DO UPDATE SET
    version_link_id = :version_link_id,
    parent_version_id = :parent_version_id,
    type = :type,
    uid = :uid,
    date_created = :date_created,
    is_checkpoint = :is_checkpoint,
    folded_counter = :folded_counter,
    uid_created = :uid_created,
    platform_created = :platform_created,
    storage_id = :storage_id,
    date_exif = :date_exif,
    date_to_remove = :date_to_remove
"""

SQL_VERSIONING_COUNT_VERSION_LINK_VERSIONS = "SELECT COUNT(*) FROM disk.version_data WHERE uid=:uid and version_link_id=:version_link_id"
SQL_VERSIONING_COUNT_VERSION_LINK_VERSIONS_GREATER_THAN_DT = """
SELECT COUNT(*) FROM disk.version_data WHERE uid=:uid and version_link_id=:version_link_id and date_created > :date_created
"""

SQL_VERSIONING_DELETE_VERSION_LINKS_WITHOUT_VERSIONS = """
DELETE FROM disk.version_links WHERE id IN (
    SELECT
        version_links.id
    FROM
        disk.version_links
    LEFT JOIN disk.version_data ON version_links.id=version_data.version_link_id
    WHERE
        version_data.version_link_id IS NULL AND version_links.date_created < NOW() - INTERVAL '1 hour'
    LIMIT :batch_size
)
"""

# На момент написания нигде не используется, но написано для консистентности
# DAO (используется только монговая реализация для чистки)
SQL_VERSIONING_GET_ALL_VERSIONS_BY_STIDS = sql_query("""
%(SELECT_VERSION_FIELDS_TEMPLATE)s
WHERE s.file_stid IN :stids OR s.digest_stid IN :stids OR s.preview_stid IN :stids
LIMIT :limit
""")

# запросы для миграции
SQL_VERSIONING_GET_VERSIONS_BY_UID = sql_query("%(SELECT_VERSION_FIELDS_TEMPLATE)s WHERE v.uid=:uid")
SQL_VERSIONING_GET_VERSION_LINKS_BY_UID = "SELECT * FROM disk.version_links WHERE uid=:uid"
SQL_VERSIONING_COUNT_VERSIONS_BY_UID = "SELECT COUNT(*) FROM disk.version_data WHERE uid=:uid"
SQL_VERSIONING_COUNT_VERSION_LINKS_BY_UID = "SELECT COUNT(*) FROM disk.version_links WHERE uid=:uid"
SQL_VERSIONING_DELETE_VERSIONS_BY_UID = "DELETE FROM disk.version_data WHERE uid=:uid"
SQL_VERSIONING_DELETE_VERSION_LINKS_BY_UID = "DELETE FROM disk.version_links WHERE uid=:uid"
