# -*- coding: utf-8 -*-
import warnings
from functools import wraps


def deprecated(fn):
    @wraps(fn)
    def wrapped(*args, **kwargs):
        warnings.warn('Call to deprecated function %s.' % fn.__name__,
                      category=DeprecationWarning)
        return fn(*args, **kwargs)
    return wrapped
