#!/usr/bin/python
# -*- coding: utf-8 -*-

from mpfs.config import settings


PLATFORM_ENABLE_ASYNC_MODE = settings.platform['enable_async_mode']


if PLATFORM_ENABLE_ASYNC_MODE:
    from gevent.local import local


def gevent_local_variables(*var_names):
    def sync_stub(cls):
        return cls

    def async_decorator(cls):
        cls__init__ = cls.__init__
        cls__getattribute__ = cls.__getattribute__
        cls__setattr__ = cls.__setattr__

        def __init__(self, *args, **kwargs):
            self._greenlet_local_data = local()  # аналог объекта threading.local, только для гринлетов, позволяет хранить специфичные для каждого гринлета данные
            cls__init__(self, *args, **kwargs)

        def __getattribute__(self, item):
            if item in var_names:
                return getattr(self._greenlet_local_data, item, None)
            return cls__getattribute__(self, item)

        def __setattr__(self, key, value):
            if key in var_names:
                setattr(self._greenlet_local_data, key, value)
            else:
                cls__setattr__(self, key, value)

        cls.__init__ = __init__
        cls.__getattribute__ = __getattribute__
        cls.__setattr__ = __setattr__

        return cls

    if PLATFORM_ENABLE_ASYNC_MODE:
        return async_decorator
    return sync_stub
