# -*- coding: utf-8 -*-


class BaseCredentials(object):
    """
    Базовый класс credentials

    Для каждой авторизации создается свой наследний этого класса. Объект класса должен содержать все данные, требуемые
    для авторизации соответствующим образом. Каждый класс должен реализовать __repr__, используемый для логоирования.
    """
    template = ''

    def __repr__(self):
        if not self.template:
            raise NotImplementedError()
        return self.template % self.__dict__


class PassportCookieCredentials(BaseCredentials):
    template = ' '.join([
        'host=%(host)s', 'origin=%(origin)s', 'http_session_cookie=%(http_session_cookie)s',
        'https_session_cookie=%(http_session_cookie)s', 'ip=%(ip)s', 'cookie_auth_client_id=%(cookie_auth_client_id)s',
        'x_uid=%(x_uid)s'])

    def __init__(self, host, origin, http_session_cookie, https_session_cookie, remote_addr, cookie_auth_client_id, x_uid):
        self.host = host
        self.origin = origin
        self.http_session_cookie = http_session_cookie
        self.https_session_cookie = https_session_cookie
        self.ip = remote_addr
        self.cookie_auth_client_id = cookie_auth_client_id
        self.x_uid = x_uid


class OAuthAuthCredentials(BaseCredentials):
    template = 'token=%(token)s'

    def __init__(self, token):
        self.token = token
