# -*- coding: utf-8 -*-

# Разделен с mpfs.platform.dynamic_settings.cache_writer из-за проблем с импортом

import time

import datetime
import yaml

from mpfs.common.errors import FailoverFileIsTooOld
from mpfs.common.util import to_json
from mpfs.config import settings
from mpfs.core.zookeeper.shortcuts import get_checksum
from mpfs.platform.common import logger


AUTH = 'auth'
LAST_TIME_MODIFICATION = 'last_time_modification'


def get_cached_auth_settings():
    logger.default_log.info('Loading auth settings from cache file, path %s' %
                            settings.platform['dynamic_settings']['cache']['file_path'])
    try:
        with open(settings.platform['dynamic_settings']['cache']['file_path']) as f:
            read_data = yaml.load(f)
        document_time = read_data[LAST_TIME_MODIFICATION]
        settings_str = to_json(read_data[AUTH])
    except Exception:
        logger.error_log.error('Couldn\'t read data from cache file', exc_info=True)
        raise

    cur_time = int(time.time())
    if cur_time - document_time > settings.platform['dynamic_settings']['cache']['maximum_age']:
        document_datetime = datetime.datetime.fromtimestamp(document_time)
        datetime_timedelta = datetime.datetime.fromtimestamp(cur_time) - document_datetime
        logger.error_log.error('Failover auth setting file is too old. File creation date is %s, time delta is %s. '
                               'These settings won\'t be used' % (document_datetime, datetime_timedelta))
        raise FailoverFileIsTooOld()

    logger.default_log.info('Successfully got auth settings from cache file, settings checksum is %s' %
                            get_checksum(read_data[AUTH]))
    return settings_str
