# -*- coding: utf-8 -*-

# Разделен с mpfs.platform.dynamic_settings.cache_reader из-за проблем с импортом

import time
import yaml

from kazoo.exceptions import ZookeeperError
from uwsgidecorators import timer, spool

from mpfs.common.util import from_json
from mpfs.config import settings
from mpfs.core.zookeeper.manager import ZookeeperClientManager
from mpfs.platform.common import logger


AUTH = 'auth'
LAST_TIME_MODIFICATION = 'last_time_modification'


def unicode_repr(self, data):
    return self.represent_str(data.encode('utf-8'))


yaml.add_representer(unicode, unicode_repr)


@spool
@timer(settings.platform['dynamic_settings']['cache']['refresh_time'])
def update_auth_settings_cache_file(env):
    """
    Спулер, переодически записывающий настройки из зукипера в локальный файл

    http://uwsgi-docs.readthedocs.io/en/latest/Spooler.html
    """
    if settings.platform['dynamic_settings']['isolate_zk']:
        return
    zk_client = None
    try:
        try:
            zk_client = ZookeeperClientManager.create_client(base_path=settings.platform['zookeeper']['base_path'])
            zk_client.start(timeout=settings.platform['zookeeper']['connection_timeout'])
        except:
            logger.error_log.error('Failed to connect to zookeeper', exc_info=True)
            return

        try:
            value, stats = zk_client.get(settings.platform['dynamic_settings']['auth_path'])
        except ZookeeperError:
            logger.error_log.error(
                'Failed to get settings from zookeeper, chroot=%s path=%s' % (
                    zk_client.chroot,
                    settings.platform['dynamic_settings']['auth_path']
                ), exc_info=True)
            return
        auth_settings = sorted(from_json(value), key=lambda x: x['name'])
        data_to_write = {
            AUTH: auth_settings,
            LAST_TIME_MODIFICATION: int(time.time())
        }

        with open(settings.platform['dynamic_settings']['cache']['file_path'], 'w') as f:
            yaml.dump(data_to_write, f, default_flow_style=False)
            logger.default_log.info('Authorization settings\'ve been written to cache file successfully, path %s' %
                                    settings.platform['dynamic_settings']['cache']['file_path'])
    finally:
        if zk_client:
            zk_client.stop()
            zk_client.close()
