# -*- coding: utf-8 -*-
from mpfs.core.zookeeper.shortcuts import get_checksum


# последние полученные настройки доступов в API (возможно еще не применённые)
__platform_auth_settings_latest__ = None
__platform_auth_checksum_latest__ = None
# настройки доступов в API, которые сейчас использует процесс (точно применённые)
__platform_auth_settings_current__ = None
__platform_auth_checksum_current__ = None


def set_platform_auth_settings_latest(value):
    """Установить значение последних полученных настроек доступов к API.

    Данная переменная может быть выставлена в любое время в рамках запроса, поэтому
    перед очередным запросом значение из этой переменной перекладывается в основную переменную
    (__platform_auth_settings_current__).
    Это защита от случая, когда измененные настройки прилетели в середине запроса и часть запроса
    выполнялась с одними настройками, а часть с другими."""
    global __platform_auth_settings_latest__
    __platform_auth_settings_latest__ = value
    global __platform_auth_checksum_latest__
    __platform_auth_checksum_latest__ = get_checksum(value)


def get_platform_auth_settings_latest():
    return __platform_auth_settings_latest__


def get_platform_auth_checksum_latest():
    return __platform_auth_checksum_latest__


def set_platform_auth_settings_current(value):
    global __platform_auth_settings_current__
    __platform_auth_settings_current__ = value
    global __platform_auth_checksum_current__
    __platform_auth_checksum_current__ = get_checksum(value)


def get_platform_auth_settings_current():
    return __platform_auth_settings_current__


def get_platform_auth_checksum_current():
    return __platform_auth_checksum_current__


def uwsgi_is_launched():
    try:
        import uwsgi
        return True
    except ImportError:
        return False
