# -*- coding: utf-8 -*-

"""
Примитивы синхронизации потоков, которые работают с динамическими настройками.
"""

import threading
import Queue

from mpfs.config import settings


if not settings.platform['enable_async_mode']:
    # threading
    auth_settings_queue = Queue.Queue()
    auth_settings_updated_after_fork_event = threading.Event()
else:
    # gevent
    import gevent.queue
    import gevent.event
    auth_settings_queue = gevent.queue.Queue()
    auth_settings_updated_after_fork_event = gevent.event.Event()
