# -*- coding: utf-8 -*-

from mpfs.core.event_dispatcher.dispatcher import EventDispatcher
from mpfs.core.zookeeper.hooks import SettingsChangeEvent


dispatcher = EventDispatcher([SettingsChangeEvent])


class EventListenerMixin(object):
    event = None

    def __init__(self, *args, **kwargs):
        super(EventListenerMixin, self).__init__(*args, **kwargs)
        if self.event is not None:
            dispatcher.subscribe(self.event, self.handle_event)

    def handle_event(self, event):
        raise NotImplementedError
