# -*- coding: utf-8 -*-
"""

MPFS
PLATFORM
API

SYSTEM HANDLER

"""
from mpfs.platform.common import PlatformResponse
from mpfs.platform.handlers import BasePlatformHandler
from mpfs.platform.permissions import AllowAllPermission


class GetPing(BasePlatformHandler):
    auth_required = False
    permissions = AllowAllPermission()

    def handle(self, request, *args, **kwargs):
        return PlatformResponse(content='pong', headers={'Content-Type': 'text/plain; charset=utf-8'})

    def check_rate_limit(self, request):
        """Проверить ограничение частоты запросов для этой ручки.

        Для этой ручки ограничение не проверяем, т.к. она служит
        для проверки жив ли сервис и всегда должна отвечать 200.
        """
        return
