# -*- coding: utf-8 -*-
import uatraits


class UserAgentDetector(object):
    UADETECTOR_DATA_BROWSER_FILE = '/usr/share/uatraits/browser.xml'
    UADETECTOR_DATA_PROFILES_FILE = '/usr/share/uatraits/profiles.xml'
    UADETECTOR_DATA_EXTRA_FILE = '/usr/share/uatraits/extra.xml'

    @staticmethod
    def parse_from_headers(headers):
        if not headers or not isinstance(headers, dict):
            return UserAgentDetails({})

        try:
            detector = UserAgentDetector.get_detector()
            details = detector.detect_by_headers(headers)
        except Exception:
            details = {}

        return UserAgentDetails(details)

    @staticmethod
    def get_detector():
        detector = uatraits.detector(UserAgentDetector.UADETECTOR_DATA_BROWSER_FILE,
                                     UserAgentDetector.UADETECTOR_DATA_PROFILES_FILE,
                                     UserAgentDetector.UADETECTOR_DATA_EXTRA_FILE)
        return detector


class UserAgentDetails(object):
    UNKNOWN = 'Unknown'

    def __init__(self, details):
        if not isinstance(details, dict):
            details = {}

        self.details = details

    def get_browser_name(self):
        return self.details.get('BrowserName', self.UNKNOWN)

    def is_mobile(self):
        return self.details.get('isMobile', False)
