# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.platform import fields
from mpfs.platform.v1.disk.handlers import GetClientsInstallerHandler

ADSCIM_SOFTWARE_INSTALLER_PATH = settings.platform['software_installer']['adscim_path']


class GetADSCIMClientsInstallerHandler(GetClientsInstallerHandler):
    installers_path = ADSCIM_SOFTWARE_INSTALLER_PATH
    kwargs = fields.QueryDict({
        'platform_id': fields.ChoiceField(
            choices=ADSCIM_SOFTWARE_INSTALLER_PATH.keys(),
            required=True,
            help_text=u"ID платформы ПО"
        ),
    })
