# -*- coding: utf-8 -*-
class BatchRequest(object):
    method = None
    url = None
    headers = None
    body = None

    def __init__(self, method, url, headers=None, body=None):
        self.method = method
        self.url = url
        self.headers = headers or {}
        self.body = body

    def __repr__(self):
        context = {'class': self.__class__.__name__}
        context.update(self.__class__.__dict__)
        context.update(self.__dict__)
        return '%(class)s(%(method)s, %(url)s, headers=%(headers)s, body=%(body)s)' % context
