# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.common import HTTP_VERBS
from mpfs.platform.serializers import BaseSerializer
from mpfs.platform.v1.batch.common import BatchRequest


class BatchRequestSerializer(BaseSerializer):
    visible_fields = ['method', 'relative_url', 'headers', 'body']
    fields = {
        'method': fields.ChoiceField(choices=HTTP_VERBS, required=True, help_text=u'HTTP-метод'),
        'relative_url': fields.StringField(required=True, source='url', help_text=u'Относительный URL'),
        'headers': fields.JsonObjectField(max_nesting_level=0, allow_list_attributes=False, help_text=u'Заголовки'),
        'body': fields.BaseField(help_text=u'Тело запроса'),
    }

    def restore_object(self, attrs, instance=None):
        return BatchRequest(attrs['method'], attrs['url'], headers=attrs.get('headers'), body=attrs.get('body'))


class BatchRequestListSerializer(BaseSerializer):
    visible_fields = ['items']
    fields = {
        'items': fields.SerializerField(BatchRequestSerializer, many=True, required=True, help_text=u'Список запросов')
    }


class BatchResponseSerializer(BaseSerializer):
    """Умеет сериализовать объекты `mpfs.platform.common.PlatformResponse`"""
    visible_fields = ['code', 'headers', 'body']
    fields = {
        'code': fields.IntegerField(required=True, source='status_code', help_text=u'HTTP-код ответа'),
        'headers': fields.JsonObjectField(source='headers', max_nesting_level=0, allow_list_attributes=False, help_text=u'Заголовки'),
        'body': fields.BaseField(source='content', help_text=u'Тело ответа'),
    }


class BatchResponseListSerializer(BaseSerializer):
    visible_fields = ['items']
    fields = {
        'items': fields.SerializerField(BatchResponseSerializer, many=True, help_text=u'Список ответов')
    }
