# -*- coding: utf-8 -*-

from mpfs.platform.exceptions import BadRequestError, FieldValidationError, GoneError, PayloadTooLargeError
from mpfs.platform.v1.case.serializers import DiskUnsupportedTLDErrorSerializer
from fields import PushkinTokenField


class PushkinTokenInvalidError(FieldValidationError):
    def __init__(self, key, **kwargs):
        name='token.%s (%s)' % (key, PushkinTokenField.keys[key])
        super(PushkinTokenInvalidError, self).__init__(name=name, **kwargs)


class PushkinTokenInvalidUUIDError(PushkinTokenInvalidError):
    def __init__(self, **kwargs):
        super(PushkinTokenInvalidUUIDError, self).__init__(key='d', **kwargs)


class DocviewerYandexuidRequiredError(BadRequestError):
    description = '"yandexuid" is required.'
    message = u'Поле "yandexuid" является обязательным.'


class DocviewerSignatureMismatchError(BadRequestError):
    description = 'Signature mismatch.'
    message = u'Неверная подпись.'


class DocviewerInvalidFileUrlError(BadRequestError):
    description = 'Invalid file_url.'
    message = u'Неверная ссылка.'


class DocviewerExpiredUrlError(GoneError):
    description = 'URL expired.'
    message = u'Ссылка устарела.'


class DiskUnsupportedTLDError(BadRequestError):
    serializer_cls = DiskUnsupportedTLDErrorSerializer
    description = 'Yandex.Disk doesn\'t support top level domain "%(unsupported_tld)s".'
    message = u'Яндекс.Диск не поддерживает домен верхнего уровня "%(unsupported_tld)s".'


class DiskCanDeleteItemSizeIsTooLarge(PayloadTooLargeError):
    description = 'The number of items to handle is too large.'
    message = u'Слишком большое количество элементов для обработки.'
