# -*- coding: utf-8 -*-

from mpfs.platform import exceptions
from mpfs.platform.fields import JsonObjectField


class PushkinTokenField(JsonObjectField):
    """
    Филд для парсинга токена в формате Пушкина:
    https://wiki.yandex-team.ru/YandexMobile/pushkin/API2/#register
    """
    keys = {
        'p': 'platform',
        'c': 'app_name', # certificate for iOS, package_name for Android, client_id for Windows
        'd': 'uuid',
        't': 'push_token',
    }
    platform_choices = [
        'i',  # iOS
        'a',  # Android
        'c',  # Courier
        'b',  # Bada
        'w',  # Windows
    ]

    def to_native(self, value):
        token = super(PushkinTokenField, self).to_native(value)
        if not isinstance(token, dict):
            return token

        return {self.keys.get(key, key): value for key, value in token.iteritems()}

    def validate(self, token):
        super(PushkinTokenField, self).validate(token)

        missing_keys = ["'%s' (%s)" % (raw_key, key) for raw_key, key in self.keys.iteritems() if key not in token]
        if missing_keys:
            raise exceptions.FieldKeyRequiredError(missing_keys)

        if token['platform'] not in self.platform_choices:
            raise exceptions.FieldWrongChoiceError(choices=self.platform_choices)


