# -*- coding: utf-8 -*-
import re

from mpfs.platform.permissions import BasePlatformPermission, ClientHasScopesPermission
from mpfs.platform.v1.case.qa.exceptions import DiskSharedFolderUserNotInternal
from mpfs.platform.v1.personality.permissions import GenericObjectsPermission
from mpfs.core.services.passport_service import passport


class ImportYTTablePermissions(GenericObjectsPermission):
    REQUEST_OBJ_SCOPE_RX = re.compile(r'^/v\d/case/personality/(?P<request_scope>.*)/import/yt')
    SCOPE_PREFIX = 'cloud_api.import.yt:generic.'


class YandexUserPermission(BasePlatformPermission):

    def has_permission(self, request):
        if passport.is_yandex_internal_qa_user(uid=request.user.uid):
            return True
        raise DiskSharedFolderUserNotInternal()


class LentaCoolBlocksReadPermission(ClientHasScopesPermission):
    """Доступ на чтение блоков ленты."""
    scopes = ('cloud_api.profile:generic.disk.cool_lenta.morda_blocks.read',)


class NostalgiaPhotoBlocksReadPermission(ClientHasScopesPermission):
    """Доступ на чтение блоков ленты для показа в ПП (фотоностальгия)."""
    scopes = ('cloud_api:photo_blocks.read',)
