# -*- coding: utf-8 -*-
from mpfs.platform.exceptions import ConflictError, BadRequestError, NotFoundError, InsufficientStorageError, \
    ForbiddenError


class DiskSharedFoldersConflictError(ConflictError):
    description = 'Shared folder creation path conflict'
    message = u'Конфликт путей при создании общей папки'


class DiskSharedFoldersBadRightsError(BadRequestError):
    description = 'Incorrect value of rights for shared folder'
    message = u'Некорректное значение прав доступа к общей папке'


class DiskSharedFoldersInviteNotFoundError(NotFoundError):
    description = 'Invite not found'
    message = u'Приглашение не найдено'


class DiskSharedFoldersUsersLimitReachedError(ConflictError):
    description = 'Shared folder users limit is reached'
    message = u'Достигнут лимит числа пользователей общей папки'


class DiskSharedFoldersLimitIsReachedError(ConflictError):
    description = 'Foreign shared folders limit is reached'
    message = u'Достигнут лимит числа чужих общих папок'


class DiskSharedFoldersNotEnoughSpaceError(InsufficientStorageError):
    description = 'Not enough space for shared folders'
    message = u'Недостаточно места для подключения общей папки'


class DiskSharedFoldersUserNotFound(NotFoundError):
    description = 'User not found'
    message = u'Не удалось найти пользователя'


class DiskSharedFolderUserNotInternal(ForbiddenError):
    description = 'User not internal'
    message = u'Пользователь не внутренний'