# -*- coding: utf-8 -*-
from collections import OrderedDict

from mpfs.platform.fields import ChoiceField


class SharedFolderRightsField(ChoiceField):
    READ_ONLY_STR = 'RO'
    READ_ONLY_INT = 640
    READ_WRITE_STR = 'RW'
    READ_WRITE_INT = 660
    RIGHTS_MAP = OrderedDict({
        READ_ONLY_STR: READ_ONLY_INT,
        READ_WRITE_STR: READ_WRITE_INT,
    })

    def __init__(self, *args, **kwargs):
        super(SharedFolderRightsField, self).__init__(choices=self.RIGHTS_MAP, *args, **kwargs)
