# -*- coding: utf-8 -*-
from collections import OrderedDict

from mpfs.platform.resources import NamespaceResource, adhoc, BaseResource
from mpfs.platform.v1.case.qa.handlers import DiskSharedFoldersCreateHandler, DiskSharedFoldersCreateInviteHandler, \
    DiskSharedFoldersAcceptInviteHandler, DiskSharedFoldersRejectInviteHandler, DiskSharedFoldersSetRightsHandler, \
    DiskSharedFoldersRevokeAccessHandler, \
    DiskSharedFoldersRemoveHandler, DiskSharedFoldersListIncomingInvitesHandler


class IncomingInviteResource(BaseResource):
    relations = {
        'accept': adhoc('PUT', DiskSharedFoldersAcceptInviteHandler),
        'reject': adhoc('PUT', DiskSharedFoldersRejectInviteHandler),
    }


class IncomingInvitesNamespace(BaseResource):
    relations = {
        'GET': DiskSharedFoldersListIncomingInvitesHandler,
        '(?P<invite_key>[^/]+)': IncomingInviteResource,
    }


class SharedFolderResource(BaseResource):
    relations = {
        'DELETE': DiskSharedFoldersRemoveHandler,
        'invites': adhoc('POST', DiskSharedFoldersCreateInviteHandler),
        'set-rights': adhoc('PUT', DiskSharedFoldersSetRightsHandler),
        'revoke-access': adhoc('PUT', DiskSharedFoldersRevokeAccessHandler),
    }


class SharedFoldersNamespace(BaseResource):
    """Операции над общими папками"""
    relations = OrderedDict([
        ('POST', DiskSharedFoldersCreateHandler),
        ('incoming-invites', IncomingInvitesNamespace),
        ('(?P<shared_folder_id>[^/]+)', SharedFolderResource),
    ])


class QANamespace(NamespaceResource):
    relations = {
        'shared-folders': SharedFoldersNamespace,
    }