# -*- coding: utf-8 -*-
from mpfs.platform.fields import StringField, IntegerField, SerializerField
from mpfs.platform.serializers import BaseSerializer, ListSerializer
from mpfs.platform.v1.disk.fields import MpfsPathField


class SharedFolderSerializer(BaseSerializer):
    visible_fields = ['shared_folder_id', 'path']
    fields = {
        'shared_folder_id': StringField(required=True, source='gid', help_text=u'Идентификатор общей папки.'),
    }


class SharedFolderIncomingInviteSerializer(BaseSerializer):
    visible_fields = ['invite_key', 'shared_folder_name', 'size']
    fields = {
        'invite_key': StringField(required=True, source='hash', help_text=u'Ключ активации приглашения.'),
        'shared_folder_name': StringField(required=True, source='folder_name', help_text=u'Имя общей папки.'),
        'size': IntegerField(required=True, help_text=u'Размер общей папки.'),
    }


class SharedFolderIncomingInvitesListSerializer(ListSerializer):
    visible_fields = ['items', 'limit', 'offset']
    fields = {
        'items': SerializerField(serializer_cls=SharedFolderIncomingInviteSerializer, many=True,
                                 help_text=u'Список приглашений.')
    }
