from mpfs.platform.resources import NamespaceResource, adhoc, BaseResource
from mpfs.platform.v1.case.handlers import (
    ImportRegionsBatchHandler,
    SaveActualFlightHandler,
    StatusAutouploadBonusHandler,
    DeleteActualFlightHandler,
    XivaSubscribeMobileHandler,
    XivaUnsubscribeMobileHandler,
    GetAutouploadLentaBlockUrlHandler,
    DocviewerYabrowserLinkHandler,
    DocviewerYabrowserFileDataHandler,
    ImportYTTableHandler,
    ImportYTTableWithIdHandler,
    GetImportOperationStatusHandler,
    DynamicSettingsChecksumHandler,
    UnlimitedAutouploadSetStatusHandler,
    UnlimitedAutouploadStatusHandler,
    WakeUpPushStart,
    WakeUpPushStop,
    CanDeleteHandler,
    GetLentaResourcesPreviewDownloadLinks,
    GetLentaBlocks,
    GetLentaBlockById,
    GetMobileMonitoringHandler,
    GetDesktopMonitoringHandler,
    SearchWarmupHandler,
    GetLentaSelectionBlockInfoHandler,
    GetLentaReportBlockVisitHandler,
    UnlimitedAutouploadsSetStatusHandler,
)
from mpfs.platform.v1.case.qa.resources import QANamespace


class PersonalityActualFlightsCaseApiResource(BaseResource):
    relations = {
        'PUT': SaveActualFlightHandler,
        'DELETE': DeleteActualFlightHandler
    }


class YTImportSpecifiedIdNamespace(NamespaceResource):
    relations = {
        'PUT': ImportYTTableWithIdHandler,
        'GET': GetImportOperationStatusHandler,
    }


class YTImportNamespace(NamespaceResource):
    relations = {
        'POST': ImportYTTableHandler,
        '(?P<import_id>[^/]+)': YTImportSpecifiedIdNamespace,
    }


class ImportResourceNamespace(NamespaceResource):
    relations = {
        'yt': YTImportNamespace,
    }


class PersonalityCaseApiNamespace(NamespaceResource):
    relations = {
        'events/flights/actual/(?P<event_id>[^/]+)': PersonalityActualFlightsCaseApiResource,
        'import-regions-batch': adhoc('POST', ImportRegionsBatchHandler),
        '(?P<resource_path>.+)/import': ImportResourceNamespace,
    }


class XivaSubscriptionResource(BaseResource):
    relations = {
        'PUT': XivaSubscribeMobileHandler,
        'DELETE': XivaUnsubscribeMobileHandler
    }


class XivaApiNamespace(NamespaceResource):
    relations = {
        'mobile/history-subscription': XivaSubscriptionResource
    }


class DocviewerApiNamespace(NamespaceResource):
    relations = {
        'ya-browser/docviewer-link': adhoc('GET', DocviewerYabrowserLinkHandler),
        'ya-browser/file-data': adhoc('GET', DocviewerYabrowserFileDataHandler),
    }


class NostalgiaApiNamespace(NamespaceResource):
    relations = {
        'GET': GetLentaResourcesPreviewDownloadLinks,
        'blocks': adhoc('GET', GetLentaBlocks),
        'blocks/(?P<block_id>[^/]+)': adhoc('GET', GetLentaBlockById),
    }


class CaseApiNamespace(NamespaceResource):
    relations = {
        'docviewer': DocviewerApiNamespace,
        'disk/32-gb-autoupload/status': adhoc('GET', StatusAutouploadBonusHandler),
        'disk/can-delete': adhoc('POST', CanDeleteHandler),
        'disk/unlimited-autoupload/status': adhoc('HEAD', UnlimitedAutouploadStatusHandler),
        'disk/unlimited-autoupload/set-state': adhoc('PUT', UnlimitedAutouploadSetStatusHandler),
        'disk/unlimited-autouploads/set-state': adhoc('PUT', UnlimitedAutouploadsSetStatusHandler),  # plural form of word autouploads
        'disk/searchapp/nostalgia': NostalgiaApiNamespace,
        'disk/ios_wake_up/autoupload': adhoc('PUT', WakeUpPushStart),
        'disk/ios_wake_up/autoupload/(?P<session_id>[^/]+)': adhoc('DELETE', WakeUpPushStop),
        'disk/clients/mobile/monitoring': adhoc('GET', GetMobileMonitoringHandler),
        'disk/clients/desktop/monitoring': adhoc('GET', GetDesktopMonitoringHandler),
        'disk/search/warmup': adhoc('PUT', SearchWarmupHandler),
        'personality': PersonalityCaseApiNamespace,
        'xiva': XivaApiNamespace,
        'lenta/autoupload_block_url': adhoc('GET', GetAutouploadLentaBlockUrlHandler),
        'lenta/selection_block_info': adhoc('GET', GetLentaSelectionBlockInfoHandler),
        'lenta/report_block_visit': adhoc('GET', GetLentaReportBlockVisitHandler),
        'cloud-api-dynamic-settings/checksum': adhoc('GET', DynamicSettingsChecksumHandler),
        'qa/disk': QANamespace,
    }
