# -*- coding: utf-8 -*-
from mpfs.platform.fields import BooleanField, StringField, IntegerField, DateTimeField, UrlField, SerializerField, ChoiceField

from mpfs.platform.serializers import BaseSerializer, ErrorWithContextSerializer


class PromoStatusSerializer(BaseSerializer):
    visible_fields = ['show_notification', ]
    fields = {
        'show_notification': BooleanField(source='show_notification', pbid=1, help_text=u'Признак того, что надо показать уведомление о действии акции'),
    }


class AutouploadLentaBlockUrlSerializer(BaseSerializer):
    visible_fields = ['block_url', 'total', 'date']
    fields = {
        'block_url': StringField(required=True, help_text=u'Ссылка на блок.'),
        'total': IntegerField(required=True, help_text=u'Кол-во ресурсов в блоке.'),
        'date': DateTimeField(required=True, help_text=u'Текущая дата.'),
    }


class DiskUnsupportedTLDErrorSerializer(ErrorWithContextSerializer, AutouploadLentaBlockUrlSerializer):
    visible_fields = ErrorWithContextSerializer.visible_fields + AutouploadLentaBlockUrlSerializer.visible_fields


class DocviewerYabrowserLinkSerializer(BaseSerializer):
    visible_fields = ['href', 'method', 'templated']
    fields = {
        'href': UrlField(source='href', help_text=u'Ссылка на docviewer.'),
        'method': StringField(source='method', help_text=u'HTTP метод ссылки.'),
        'templated': BooleanField(source='templated', help_text=u'Есть ли в ссылке шаблонные параметры.'),
    }


class DocviewerYabrowserFileDataSerializer(BaseSerializer):
    visible_fields = ['mds_key']
    fields = {
        'mds_key': StringField(source='mds_key', help_text=u'Расшифрованный mds_key.'),
    }


class WakeUpSessionIdSerializer(BaseSerializer):
    visible_fields = ['session_id']
    fields = {
        'session_id': StringField(source='session_id', help_text=u'Идентификатор wake_up сессии.'),
    }


class UnlimitedAutouploadSetStatusRequestSerializer(BaseSerializer):
    visible_fields = ['activate']
    fields = {
        'activate': BooleanField(required=True, help_text=u'Включить или выключить безлимитную автозагрузку с телефона.'),
    }


class UnlimitedAutouploadsSetStatusRequestSerializer(BaseSerializer):
    visible_fields = ['unlimited_video_autoupload_enabled', 'unlimited_photo_autoupload_enabled']
    fields = {
        'unlimited_video_autoupload_enabled': BooleanField(required=False, default=None, help_text=u'Включить или выключить безлимитную автозагрузку видео с телефона.'),
        'unlimited_photo_autoupload_enabled': BooleanField(required=False, default=None, help_text=u'Включить или выключить безлимитную автозагрузку фото с телефона.'),
    }


class UnlimitedAutouploadsGetStatusRequestSerializer(UnlimitedAutouploadsSetStatusRequestSerializer):
    visible_fields = ['unlimited_video_autoupload_enabled', 'unlimited_photo_autoupload_enabled', 'unlimited_video_autoupload_reason']
    fields = {
        'unlimited_video_autoupload_reason': ChoiceField(
            required=True,
            help_text=u'Причина состояния безлимитной автозагрузки видео с телефона.'),
    }


class CanDeleteItemBodySerializer(BaseSerializer):
    """Элемент файла для проверки на возможность удаления"""
    visible_fields = ['size', 'md5', 'sha256']
    fields = {
        'size': IntegerField(help_text=u'Размер файла.'),
        'md5': StringField(help_text=u'MD5-хэш.'),
        'sha256': StringField(help_text=u'SHA256-хэш.'),
    }


class CanDeleteListBodySerializer(BaseSerializer):
    """Сериализатор тела пользовательского запроса на проверку возможности удаления файла с локального устройства"""
    visible_fields = ['items']
    fields = {
        'items': SerializerField(CanDeleteItemBodySerializer, many=True, help_text=u'Хэши файлов, которые проверяем на возможность удаления с локального устройства.'),
    }


class CanDeleteItemResponseSerializer(BaseSerializer):
    """Элемент файла для проверки на возможность удаления"""
    visible_fields = ['resource_id', 'can_delete']
    fields = {
        'resource_id': StringField(help_text=u'Идентификатор ресурса.'),
        'can_delete': BooleanField(help_text=u'Идентификатор того, что файл можно удалить локально.')
    }


class CanDeleteListResponseSerializer(BaseSerializer):
    """Сериализатор тела ответа на запрос на проверку возможности удаления файла с локального устройства"""
    visible_fields = ['items']
    fields = {
        'items': SerializerField(CanDeleteItemResponseSerializer, many=True, help_text=u'Список ответов на запрос о возможности удаления файла с локального устройства.'),
    }
