# -*- coding: utf-8 -*-
from mpfs.platform.v1.batch.common import BatchRequest


class ChainRequest(BatchRequest):
    """
    :param subrequest: Список подзапросов типа BatchRequest.
    """
    subrequests = []

    def __init__(self, method, url, headers=None, body=None, subrequests=[]):
        super(ChainRequest, self).__init__(method, url, headers=headers, body=body)
        self.subrequests = subrequests

    def __repr__(self):
        context = {'class': self.__class__.__name__}
        context.update(self.__class__.__dict__)
        context.update(self.__dict__)
        return ('%(class)s(%(method)s, %(url)s, headers=%(headers)s, body=%(body)s, subrequests=%(subrequests)s)' %
                context)
