# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.platform import exceptions


PLATFORM_CHAINING_MAX_SUBREQUESTS = settings.platform['chaining']['max_subrequests']


class ChainingApplyTemplateError(exceptions.BadRequestError):
    description = 'Chain request template is malformed.'
    message = u'Неверно составлен шаблон запроса.'


class ChainingTooManySubrequestsError(exceptions.BadRequestError):
    description = 'Too many sub-requests for chaining. Max subrequests number is %s' % PLATFORM_CHAINING_MAX_SUBREQUESTS
    message = (u'Слишком много подзапросов для выполнения chain-запроса. Максимальное число подзапросов равно %s' %
               PLATFORM_CHAINING_MAX_SUBREQUESTS)


class ChainingForbiddenNestedContainerRequestError(exceptions.BadRequestError):
    description = 'Forbidden to use nested chain or batch requests in chain request'
    message = u'Запрещено использовать вложенные chain или batch запросы в chain-запросе'
