# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.v1.batch.serializers import (
    BatchRequestSerializer,
    BatchResponseSerializer
)
from mpfs.platform.v1.chaining.common import ChainRequest


class ChainRequestSerializer(BatchRequestSerializer):
    visible_fields = BatchRequestSerializer.visible_fields + ['subrequests']
    fields = {
        'subrequests': fields.SerializerField(lambda: BatchRequestSerializer, many=True, help_text=u'Список подзапросов')
    }

    def restore_object(self, attrs, instance=None):
        return ChainRequest(attrs['method'], attrs['url'], headers=attrs.get('headers'), body=attrs.get('body'),
                            subrequests=attrs.get('subrequests'))


class ChainResponseSerializer(BatchResponseSerializer):
    visible_fields = BatchResponseSerializer.visible_fields + ['subrequests']
    fields = {
        'subrequests': fields.SerializerField(BatchResponseSerializer, many=True, help_text=u'Список ответов на подзапросы')
    }
