# -*- coding: utf-8 -*-
from mpfs.platform import exceptions


class CommentsBadRequestError(exceptions.BadRequestError):
    pass


class CommentsBadRequestBodyError(exceptions.BadRequestError):
    pass


class CommentsReplyToReplyError(exceptions.BadRequestError):
    description = 'Can not reply to replies to comment'


class CommentsNotAuthenticatedError(exceptions.UnauthorizedError):
    pass


class CommentsForbiddenError(exceptions.ForbiddenError):
    pass


class CommentsDisabledError(exceptions.ForbiddenError):
    description = 'Entity is disabled to be liked or commented'


class CommentsNotFoundError(exceptions.NotFoundError):
    pass


class CommentsMethodNotAllowedError(exceptions.MethodNotAllowedError):
    pass


class CommentsRateLimitExceededError(exceptions.TooManyRequestsError):
    pass


class CommentsSpamDetectedError(exceptions.TooManyRequestsError):
    pass
