# -*- coding: utf-8 -*-
import re
from mpfs.platform import exceptions


class DataNotFoundError(exceptions.NotFoundError):
    pass


class DataMethodNotAllowedError(exceptions.MethodNotAllowedError):
    pass

class DataBadRequestError(exceptions.BadRequestError):
    pass

class DataInvalidDeltaError(exceptions.BadRequestError):
    description = 'Unable to apply delta'
    message = u'Не удалось применить изменение. Возможно изменение конфликтует с текущим состоянием базы данных.'


class DataTypeDoesntMatchValueError(exceptions.BadRequestError):
    description = 'Value for type "%(type)s" must be set in appropriate attribute "%(type)s".'
    message = u'Значение типа "%(type)s" должно быть задано соответствующим аттрибутом "%(type)s".'


class DataValueObjectProvideMultipleValuesError(exceptions.BadRequestError):
    description = 'Multiple values provided in Value object.'
    message = (u'Объект Value содержит несколько значений для различных типов данных. '
               u'Value может содержать значение только для одного типа данных.')


class DataTooOldDeltaError(exceptions.GoneError):
    description = ('Your are trying to apply delta which was created for obsolete revision of database. '
                   'You must get fresh snapshot of database to synchronize.')
    message = (u'Вы пытаетесь применить изменение созданное для сильно устаревшей ревизии базы данных. '
               u'Прежде чем применить изменение, необходимо обновить локальную копию базы данных получив свежий снапшот.')


class DataFieldSetWithoutValueError(exceptions.BadRequestError):
    description = 'If change_type is "set" or "list_item_set" then "value" attribute must be specified.'
    message = u'Если change_type равен "set" или "list_item_set", то должен быть задан атрибут "value".'


class DataFieldListItemWithoutIndexError(exceptions.BadRequestError):
    description = ('If change_type is one of "list_item" operations '
                   'then item index must be specified in "list_item" attribute.')
    message = (u'Если change_type является одной из операций над элемнетами списка, то номер элемента должен быть '
               u'задан атрибутом "list_item".')


class DataFieldListItemMoveWithoutDestError(exceptions.BadRequestError):
    description = 'If change_type is "list_item_move" then "list_item_dest" attribute must be specified.'
    message = u'Если change_type равен "list_item_move", то должен быть задан атрибут "list_item_dest".'


class DataDeltasForRevisionIsGoneError(exceptions.GoneError):
    description = 'Requested revision is too old and deltas for it is gone. ' \
                  'You must get fresh snapshot of database to synchronize.'
    message = u'Запрошенная ревизия слишком сильно устарела и список изменений для неё уже недоступен. ' \
              u'Для синхронизации локальной копии базы данных необходимо получить свежий снапшот.'


class DataDeltaIsNewerThanDatabaseRevisionError(exceptions.PreconditionFailedError):
    description = 'You are trying to apply delta which created for newer version of database than we have.'
    message = u'Вы пытаетесь применить изменение созданное для более новой ревизии базы данных чем на сервере. ' \
              u'Либо примените сначала пропущенные изменения, ' \
              u'либо обновите локальную копию базы данных получив свежий снапшот.'
    CURRENT_REVISION_RE = re.compile(r'"message":"Current rev: (?P<revision>\d+),')

    def __init__(self, *args, **kwargs):
        super(DataDeltaIsNewerThanDatabaseRevisionError, self).__init__(*args, **kwargs)
        if self.inner_exception:
            data = getattr(self.inner_exception, 'data', {})
            raw_resp = data.get('text', '')
            match = self.CURRENT_REVISION_RE.search(raw_resp)
            if match:
                revision = int(match.groupdict().get('revision'))
                self.headers['ETag'] = revision


class DataInvalidIdError(exceptions.BadRequestError):
    description = 'Database, collection or record ID provided in request is incorrect.'
    message = u'Идентификатор базы данных, коллекции или записи указанный в запросе некорректен.'


class DataReadOnlyError(exceptions.LockedError):
    description = 'Requested resource is read-only.'
    message = u'Запрошенный ресурс доступен только для чтения.'


class DataDatabaseSizeLimitExceededError(exceptions.InsufficientStorageError):
    description = 'Database reached size limit.'
    message = u'Размер базы данных достиг максимального значения.'


class DataDatabasesNumberLimitExceededError(exceptions.InsufficientStorageError):
    description = 'Number of databases has reached the maximum.'
    message = u'Количество баз данных достигло максимального значения.'


class DataInvalidSchemaError(exceptions.BadRequestError):
    description = 'Request body has invalid schema.'
    message = u'Тело запроса содержит данные в неверном формате.'


class DataValidationError(exceptions.BadRequestError):
    description = 'Parameters validation failed.'
    message = u'Переданные параметры содержат недопустимые значения.'


class DataAppSubscriptionIdValidationError(exceptions.FieldValidationError):
    description = 'Incorrect subscription identifier.'
    message = u'Указан некорректный идентификатор подписки.'
