# -*- coding: utf-8 -*-
from mpfs.platform.resources import NamespaceResource, BaseResource, adhoc
from mpfs.platform.v1.data.handlers import (
    ListDatabasesHandler, GetOrCreateDatabaseHandler, GetDatabaseHandler,
    DeleteDatabaseHandler, GetSnapshotHandler, SetRevisionHandler,
    CreateDeltaHandler, ListDeltasHandler, UpdateDatabaseHandler,
    ListAppUsersHandler, GetWebSubscriptionUrlHandler,
    GetCallbackSubscriptionUrlHandler, CreateAppSubscriptionHandler, DeleteAppSubscriptionHandler
)


class DeltasCollection(BaseResource):
    """Изменения данных"""
    relations = {
        'GET': ListDeltasHandler,
        'POST': CreateDeltaHandler,
    }


class DatabaseResource(BaseResource):
    """База данных"""
    relations = {
        'GET': GetDatabaseHandler,
        'PUT': GetOrCreateDatabaseHandler,
        'DELETE': DeleteDatabaseHandler,
        'PATCH': UpdateDatabaseHandler,
        'snapshot': adhoc('GET', GetSnapshotHandler),
        'set-revision': adhoc('PUT', SetRevisionHandler),
        'deltas': DeltasCollection,
    }


class AppSubscriptionDetailResource(BaseResource):
    relations = {
        'DELETE': DeleteAppSubscriptionHandler
    }


class AppSubscriptionResource(BaseResource):
    """Подписки и отписки приложений на уведомления."""
    relations = {
        'PUT': CreateAppSubscriptionHandler,
        '(?P<subscription_id>[^/]+)': AppSubscriptionDetailResource
    }


class DatabasesCollection(BaseResource):
    """Data API"""
    relations = {
        'GET': ListDatabasesHandler,
        '(?P<database_id>[a-z0-9_\-\.@%]+)': DatabaseResource,
    }


class SubscriptionsNamespace(BaseResource):
    """Подписки на нотификации о событиях DataSync API"""
    relations = {
        'web': adhoc('GET', GetWebSubscriptionUrlHandler),
        'app': AppSubscriptionResource,
        'callback': adhoc('GET', GetCallbackSubscriptionUrlHandler),
    }


class DataNamespace(NamespaceResource):
    """Data API"""
    relations = {
        '(?P<context>[^/]+)/databases': DatabasesCollection,
        'users': adhoc('GET', ListAppUsersHandler),
        'subscriptions': SubscriptionsNamespace,
    }
