# -*- coding: utf-8 -*-
from mpfs.platform import exceptions


class DiskProductNotFoundError(exceptions.NotFoundError):
    description = 'Product not found.'
    message = u'Продукт не найден.'


class DiskServiceAlreadyProlongatedError(exceptions.ConflictError):
    description = 'Already prolongated.'
    message = u'Уже продлили.'


class DiskServiceMultiProvidingError(exceptions.ConflictError):
    description = 'Service already provided.'
    message = u'Услуга по продукту "%(product_id)s" уже предоставлена.'


class DiskServiceNotProlongableError(exceptions.ConflictError):
    description = 'Service not prolongable.'
    message = u'Услуга непродливаемая.'


class DiskServiceNotFoundError(exceptions.NotFoundError):
    description = 'Service not found.'
    message = u'Услуга не найдена.'


class DiskClientNotBoundToMarketError(exceptions.NotFoundError):
    description = 'Client is not bound to market.'
    message = u'Клиент не привязан к рынку.'
