# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.serializers import BaseSerializer, ListSerializer


class ProcessInappReceiptBodySerializer(BaseSerializer):
    visible_fields = ["receipt"]
    fields = {"receipt": fields.StringField(required=True, help_text=u"идентификатор чека")}


class BillingInappProductSerializer(BaseSerializer):
    visible_fields = ["product_id", "display_space", "display_space_units", "space"]
    fields = {
        "product_id": fields.StringField(required=True, help_text=u"ID продукта за период."),
        "display_space": fields.IntegerField(required=True, help_text=u"Объем предоставляемого места для отображения."),
        "display_space_units": fields.StringField(
            required=True, help_text=u"Единицы измерения для поля display_space."
        ),
        "space": fields.IntegerField(required=True, help_text=u"Объем предоставляемого места в байтах."),
    }


class BillingInappProductsListSerializer(ListSerializer):
    visible_fields = ["items", "total"]
    fields = {"items": fields.SerializerField(BillingInappProductSerializer, many=True, help_text=u"Список продуктов")}


class BillingInAppTariffProductSerializer(BaseSerializer):
    visible_fields = ["product_id"]
    fields = {
        "product_id": fields.StringField(required=True, help_text=u"ID продукта."),
    }


class BillingInAppTariffPeriodsSerializer(BaseSerializer):
    visible_fields = ["month", "year"]
    fields = {
        "month": fields.SerializerField(BillingInAppTariffProductSerializer, required=False, help_text=u"Месячный продукт тарифа."),
        "year": fields.SerializerField(BillingInAppTariffProductSerializer, required=False, help_text=u"Годовой продукт тарифа."),
    }


class BillingInAppTariffsSerializer(BaseSerializer):
    visible_fields = ["is_best_offer", "id", "periods"]
    fields = {
        "is_best_offer": fields.BooleanField(required=True, help_text=u"Лучшее предложение."),
        "id": fields.StringField(required=True, help_text=u"ID тарифа."),
        "periods": fields.SerializerField(BillingInAppTariffPeriodsSerializer, required=True, help_text=u"Периоды тарифа."),
    }


class BillingInAppTariffsSerializer(BaseSerializer):
    visible_fields = ["items", "payment_method", "current_product"]
    fields = {
        "payment_method": fields.StringField(required=True, help_text=u"Способ оплаты."),
        "items": fields.SerializerField(BillingInAppTariffsSerializer, many=True, help_text=u"Список "),
        "current_product": fields.SerializerField(BillingInAppTariffProductSerializer, required=False, help_text=u"Текущий активные продукт"),
    }
