# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.permissions import AllowByClientIdPermission
from mpfs.platform.v1.case.handlers import PLATFORM_MOBILE_APPS_IDS
from mpfs.platform.v1.disk.deletion_log.serializers import DeletionLogResponseSerializer
from mpfs.platform.v1.disk.handlers import MpfsProxyHandler


class ReadDeletionLogHandler(MpfsProxyHandler):
    permissions = AllowByClientIdPermission(PLATFORM_MOBILE_APPS_IDS)
    hidden = True
    service_url = '/json/read_deletion_log?uid=%(uid)s&deletion_log_revision=%(deletion_log_revision)s'

    query = fields.QueryDict({
        'deletion_log_revision': fields.IntegerField(required=True, help_text=u'Ревизия лога удалений.'),
    })

    serializer_cls = DeletionLogResponseSerializer

    def serialize(self, obj, *args, **kwargs):
        for i in obj['items']:
            i['source_ids'] = [{'source_id': x} for x in i['source_ids']]
        return super(ReadDeletionLogHandler, self).serialize(obj, *args, **kwargs)
