# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.serializers import BaseSerializer
from mpfs.platform.v1.disk.source_ids.serializers import SourceIdSerializer


class DeletionLogRecordSerializer(BaseSerializer):
    fields = {
        'resource_id': fields.StringField(help_text=u'Идентификатор ресурса'),
        'is_live_photo': fields.BooleanField(default=False, help_text=u'Идентификатор того, что файл является live photo.'),
        'source_ids': fields.SerializerField(SourceIdSerializer, many=True, required=True, help_text=u'Список source id.'),
        'deletion_log_revision': fields.IntegerField(required=True, help_text=u'Ревизия лога удалений'),
    }


class DeletionLogResponseSerializer(BaseSerializer):
    fields = {
        'total': fields.IntegerField(required=True, help_text=u'Количество записей'),
        'deletion_log_revision': fields.IntegerField(required=True, help_text=u'Ревизия лога удалений'),
        'items': fields.SerializerField(DeletionLogRecordSerializer, many=True, help_text=u'Записи лога удалений'),
    }
