# -*- coding: utf-8 -*-
"""
Используем отдельный модуль для сериализаторов исключений,
т.к. основной модуль сериализаторов загружен зависимостями, создавая рекурсивные импорты.
"""
from mpfs.platform.fields import StringField, IntegerField
from mpfs.platform.serializers import ErrorWithContextSerializer


class UploadLimitExceededWithDetailsSerializer(ErrorWithContextSerializer):
    visible_fields = ErrorWithContextSerializer.visible_fields + ['reason', 'limit']

    fields = {
        'reason': StringField(help_text=u'Причина срабатывания лимита.'),
        'limit': IntegerField(help_text=u'Значение лимита.'),
    }
