# -*- coding: utf-8 -*-
from mpfs.platform import exceptions
from mpfs.platform.v1.disk.exception_serializers import UploadLimitExceededWithDetailsSerializer


class DiskAreaDoesNotExistsError(exceptions.BadRequestError):
    description = 'Specified area "%(area)s" does not exist'
    message = u'Указанная область Диска "%(area)s" не существует.'


class DiskPathFormatError(exceptions.BadRequestError):
    description = 'Specified path "%(path)s" has incorrect format'
    message = u'Указанный формат ресурса Диска "%(path)s" не корректен. Должен начинаться с /.'


class DiskNotFoundError(exceptions.NotFoundError):
    description = 'Resource not found.'
    message = u'Не удалось найти запрошенный ресурс.'


class DiskOperationNotFoundError(exceptions.NotFoundError):
    description = 'Operation not found.'
    message = u'Не удалось найти  операцию.'


class DiskPathPointsToExistentDirectoryError(exceptions.ConflictError):
    description = 'Specified path "%(path)s" points to existent directory.'
    message = u'По указанному пути "%(path)s" уже существует папка с таким именем.'


class DiskPathDoesntExistsError(exceptions.ConflictError):
    description = 'Specified path "%(path)s" doesn\'t exists.'
    message = u'Указанного пути "%(path)s" не существует.'


class DiskResourceAlreadyExistsError(exceptions.ConflictError):
    description = 'Resource "%(path)s" already exists.'
    message = u'Ресурс "%(path)s" уже существует.'


class DiskResourceLockedError(exceptions.LockedError):
    description = 'Resource is locked.'
    message = u'Ресурс заблокирован. Возможно, над ним выполняется другая операция.'


class DiskServiceUnavailableError(exceptions.ServiceUnavailableError):
    pass


class DiskStorageQuotaExhaustedError(exceptions.InsufficientStorageError):
    description = 'You have exhausted storage quota.'
    message = u'Недостаточно свободного места.'


class DiskOwnerStorageQuotaExhaustedError(exceptions.InsufficientStorageError):
    description = 'Owner of shared folder has exhausted storage quota.'
    message = u'У владельца общей папки недостаточно свободного места.'


class DiskRemoveNotEmptyFolderNonRecursivelyError(exceptions.BadRequestError):
    description = 'Unable to remove not empty folder non recursively.'
    message = u'Невозможно удалить не пустой каталог не рекурсивно.'


class DiskReadOnlyError(exceptions.LockedError):
    description = 'Requested resource is read-only.'
    message = u'Запрошенный ресурс доступен только для чтения.'


class DiskPhotosliceNumberLimitExceededError(exceptions.InsufficientStorageError):
    description = 'Number of photoslice instances has reached the maximum.'
    message = u'Количество экземпляров фотосреза достигло максимального значения.'


class DiskPhotoAlbumCoverIndexOutOfRangeError(exceptions.BadRequestError):
    description = 'Cover index out of range.'
    message = u'Неверно указан индекс обложки.'


class DiskPhotoAlbumNotFoundError(exceptions.NotFoundError):
    description = 'Photo album not found.'
    message = u'Не удалось найти переданный альбом.'


class DiskPhotoAlbumNotPublicError(exceptions.ConflictError):
    description = 'Photo album is not public.'
    message = u'Фотоальбом не открыт для публичного доступа.'


class EmailNotFoundError(exceptions.NotFoundError):
    description = 'Email not found.'
    message = u'Не удалось найти переданный email.'


class UidNotFoundError(exceptions.NotFoundError):
    description = 'uid not found'
    message = u'Не удалось найти переданный uid.'


class DiskPhotoAlbumIncorrectProviderError(exceptions.NotFoundError):
    description = 'Provider not found.'
    message = u'Не удалось найти социальную сеть.'


class DiskMailAttachServiceFileIDFormatError(exceptions.BadRequestError):
    description = 'Specified service_file_id "%(service_file_id)s" has incorrect format.'
    message = (u'Указанный формат service_file_id "%(service_file_id)s" не корректен. '
               u'Должен иметь вид {mail_mid}/{mail_hid}.')


class IncorrectResourceIdFormatError(exceptions.BadRequestError):
    description = 'Specified resource identifier \"%(resource_id)s\" has incorrect format.'
    message = u'Указанный формат идентификатора ресурса \"%(resource_id)s\" не корректен.'


class DiskRevisionNotFoundError(exceptions.GoneError):
    description = 'Revision not found.'
    message = u'Не удалось найти запрошенную ревизию.'


class DiskUserBlockedError(exceptions.ForbiddenError):
    description = 'User is blocked.'
    message = u'Пользователь заблокирован.'


class DiskAPIDisabledForOverdraftUserError(exceptions.ForbiddenError):
    description = 'API unavailable. Files exceed available storage space. Delete unnecessary files or increase your Yandex.Disk storage space.'
    message = u'API недоступно. Ваши файлы занимают больше места, чем у вас есть. Удалите лишнее или увеличьте объём Диска.'


class DiskUnsupportedUserAccountTypeError(exceptions.ForbiddenError):
    description = 'User account type is not supported.'
    message = u'Тип аккаунта пользователя не поддерживается.'


class DiskNoWritePermissionForSharedFolderError(exceptions.ForbiddenError):
    description = 'User hasn\'t write permission for shared folder.'
    message = u'Не достаточно прав для изменения данных в общей папке.'


class DiskUploadTrafficLimitExceeded(exceptions.LockedError):
    error_serializer_cls = UploadLimitExceededWithDetailsSerializer
    description = 'Upload unavailable. Upload traffic limit has been reached.'
    message = u'Загрузка файлов недоступна, можно только просматривать и скачивать. Вы достигли ограничения по загрузке файлов.'


class DiskUploadFileSizeLimitExceeded(exceptions.PayloadTooLargeError):
    error_serializer_cls = UploadLimitExceededWithDetailsSerializer
    description = 'Upload unavailable. This file is too big.'
    message = u'Загрузка файла недоступна. Файл слишком большой.'


class DiskUserReadOnly(exceptions.LockedError):
    description = 'User is in read-only mode.'
    message = u'Технические работы. Сейчас можно только просматривать и скачивать файлы.'


class DiskUserNotFoundError(exceptions.NotFoundError):
    description = 'Disk not found for user.'
    message = u'Не удалось найти Диск указанного пользователя.'


class DiskExperimentsUnsupportedDevice(exceptions.BadRequestError):
    description = 'Unsupported device'
    message = u'Запрос не от мобильного клиента или неизвестный тип устройства.'


class DiskFolderDeletionByResourceIdForbiddenError(exceptions.BadRequestError):
    description = 'Folder deletion by resource_id is forbidden'
    message = u'Удаление папок через resource_id запрещено.'


class MD5CheckNotSupportedError(exceptions.BadRequestError):
    description = 'md5 check supported only for files'
    message = u'Проверка md5 возможна только для файлов'


class MD5DifferError(exceptions.ConflictError):
    description = 'Resource md5 is different from provided'
    message = u'md5 ресурса не совпадает с переданным'


class DiskClientBadRequest(exceptions.BadRequestError):
    description = 'Bad request from client'
    message = u'Некорректный запрос'


class DiskPublicKeyFormatError(exceptions.BadRequestError):
    description = 'Invalid public key format.'
    message = u'Некорректный формат public key.'


class DiskPaymentRequired(exceptions.PaymentRequired):
    description = 'Payment Required'
    message = u'Необходима оплата'


class DiskPhotoUnlimPaymentRequired(exceptions.PaymentRequired):
    description = 'Photounlim Payment Required'
    message = u'Необходима оплата для включения фотобезлимита'


class DiskAlbumsNotFound(exceptions.NotFoundError):
    description = 'Albums not found'
    message = u'Альбомы не найдены'


class DiskAlbumDeltaRevisionIsTooOld(exceptions.GoneError):
    description = 'Delta with current revision is expired'
    message = u'Дельта с запрошенной ревизией устарела'


class DiskAlbumAlreadyExists(exceptions.ConflictError):
    description = 'Album already exists. album_id: %(album_id)s.'
    message = u'Альбом уже существует. album_id: %(album_id)s.'


class DiskAlbumUnableToDelete(exceptions.ForbiddenError):
    description = 'Album can not be deleted'
    message = u'Альбом нельзя удалить'


class DiskAlbumUnableToPublish(exceptions.ForbiddenError):
    description = 'Album can not be published'
    message = u'Альбом нельзя опубликовать'


class DiskAlbumsUnableToAppendItem(exceptions.NotFoundError):
    description = 'Unable to append item.'
    message = 'Не удалось добавить элемент к альбому'


class DiskOfficeUnsupportedExtensionError(exceptions.UnsupportedMediaTypeError):
    description = 'Unsupported file extension.'
    message = u'Редактирование не поддерживает данный тип файла.'


class DiskOfficeIsDisabledError(exceptions.ForbiddenError):
    description = 'Office editor is disabled.'
    message = u'Редактирование офисных файлов отключено.'


class DiskMoveWrongDestinationError(exceptions.ForbiddenError):
    description = 'Wrong destination for move'
    message = u'Неправильное новое положение для ресурса'


class DiskFolderTooDeepError(exceptions.ForbiddenError):
    description = 'Folder depth limit exceeded'
    message = u'Достигнут предел вложенности папок'


class VideoStreamingUnprocessableEntity(exceptions.UnprocessableEntityError):
    description = 'VideoStreaming unprocessable entity'
    message = u'Ресурс не удалось обработать'


class DiskResourceDownloadLimitExceededError(exceptions.TooManyRequestsError):
    description = 'Download limit exceeded for resource'
    message = u'Превышен лимит скачивания'
