# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import collections

from mpfs.platform.resources import adhoc, BaseResource, NamespaceResource
from mpfs.platform.v1.disk.lenta import handlers


class BlockDetailResource(BaseResource):
    relations = {
        'DELETE': handlers.LentaDeleteBlockHandler
    }


class BlocksResource(BaseResource):
    relations = collections.OrderedDict([
        ('generate', adhoc('POST', handlers.LentaGenerateBlockHandler)),
        ('types/(?P<lenta_block_type>[^/]+)', adhoc('POST', handlers.LentaCreateBlockHandler)),
        ('(?P<lenta_block_id>[^/]+)', BlockDetailResource)
    ])


class ResourcesResource(BaseResource):
    relations = {
        'GET': handlers.LentaResourcesHandler,
        'create-album': adhoc('POST', handlers.LentaCreateAlbumFromBlockHandler, hidden=True),
        'publish': adhoc('PUT', handlers.LentaBlockPublicLinkHandler, hidden=True),
    }


class LentaNamespace(NamespaceResource):
    relations = {
        'resources': ResourcesResource,
        'blocks': BlocksResource,
        'report-bad-block': adhoc('GET', handlers.LentaReportBadBlockHandler, hidden=True),
    }
