# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from mpfs.platform.fields import IntegerField, StringField, SerializerField, ListField
from mpfs.platform.v1.disk.serializers import BaseSerializer, ListSerializer, ResourceSerializer, InternalUserSerializer


class LentaResourceSerializer(ResourceSerializer):
    visible_fields = ResourceSerializer.visible_fields + ['users', 'modified_by_uid']
    excluded_fields = ['_links']
    fields = {
        '_embedded': SerializerField(lambda: LentaResourceListSerializer, pbid=13,
                                     help_text=u'Список вложенных ресурсов'),
        'users': SerializerField(lambda: InternalUserSerializer, source='meta.users', many=True,
                                 help_text=u'Список пользователей идентификаторы которых присутствуют в ответе'),
        'modified_by_uid': StringField(source='meta.modify_uid',
                                       help_text=u'Идентификатор пользователя, изменившего ресурс последним')
    }


class LentaResourceListSerializer(ListSerializer):
    DEFAULT_LIMIT = 100
    visible_fields = ['limit', 'offset', 'items', 'iteration_key', 'total']

    fields = {
        'items': SerializerField(lambda: LentaResourceSerializer, many=True, required=True, pbid=1,
                                 help_text=u'Элементы списка'),
        'iteration_key': StringField(required=True, help_text='Ключ итерации',
                                     default=None),
        'total': IntegerField(required=True, help_text='Общее количество результатов',
                              default=None)
    }


class LentaBlockPublicLinkBodySerializer(BaseSerializer):
    visible_fields = ['id', 'type', 'url', 'short_url', 'short_url_named']

    # body - блок ленты
    fields = {
        'id': StringField(required=True, source='id', pbid=1, help_text='id'),
        'type': StringField(required=True, source='type', pbid=2, help_text='type'),
        'files_count': IntegerField(required=False, source='files_count', pbid=3, help_text='files_count'),
        'media_type': StringField(required=False, source='media_type', pbid=4, help_text='media_type'),
        'folder_id': StringField(required=False, source='folder_id', pbid=5, help_text='folder_id'),
        'revision': IntegerField(required=False, source='revision', pbid=6, help_text='revision'),
        'area': StringField(required=False, source='area', pbid=7, help_text='area'),
        'collection_id': StringField(required=False, source='collection_id', pbid=8, help_text='collection_id'),
        'action': StringField(required=False, source='action', pbid=9, help_text='action'),
        'order': IntegerField(required=False, source='order', pbid=10, help_text='order'),
        'modifier_uid': StringField(required=False, source='modifier_uid', pbid=11, help_text='modifier_uid'),
        'mtime': IntegerField(required=False, source='mtime', pbid=12, help_text='mtime)'),
        'mfrom': IntegerField(required=False, source='mfrom', pbid=13, help_text='mfrom)'),
        'group_key': StringField(required=False, source='group_key', pbid=14, help_text='group_key)'),
        'mtill': IntegerField(required=False, source='mtill', pbid=15, help_text='mtill)'),
        'interval_start': IntegerField(required=False, source='interval_start', pbid=16, help_text='interval_start'),
        'resource_ids': ListField(required=False, source='resource_ids', pbid=17, help_text='resource_ids'),
        'interval_end': IntegerField(required=False, source='interval_end', pbid=18, help_text='interval_end'),
        'years_ago': IntegerField(required=False, source='years_ago', pbid=19, help_text='years_ago'),
        'icon_type': StringField(required=False, source='icon_type', pbid=20, help_text='icon_type'),
    }
