# -*- coding: utf-8 -*-
from mpfs.platform.exceptions import ForbiddenError
from mpfs.platform.permissions import AllowAllPermission, ClientHasScopesPermission, DynamicScopesPermission


class WebDavPermission(ClientHasScopesPermission):
    """
    Доступ на диск с WebDAV токеном

    Такие токены (со скоупом yadisk:all) есть только у наших собственных приложений: мобильных и десктопных.
    """
    scopes = ("yadisk:all",)


class DiskReadPermission(ClientHasScopesPermission):
    """Доступ на чтение всего Диска."""
    scopes = ('cloud_api:disk.read',)


class DiskWritePermission(ClientHasScopesPermission):
    """Доступ на запись всего Диска."""
    scopes = ('cloud_api:disk.write',)


class DiskInfoPermission(ClientHasScopesPermission):
    """Доступ к информации о Диске."""
    scopes = ('cloud_api:disk.info',)


class DiskAppFolderPermission(ClientHasScopesPermission):
    """Доступ к папке приложения в Диске"""
    scopes = ('cloud_api:disk.app_folder',)

    def __init__(self, query_field=None):
        """
        :param query_field: Имя querystring параметра для которого проверяется право на доступ.
                            Если не задан, то проверяется просто наличие соответстующего скоупа у клиента.
        """
        super(DiskAppFolderPermission, self).__init__()
        self.query_field = query_field

    def has_permission(self, request):
        if not super(DiskAppFolderPermission, self).has_permission(request):
            return False
        elif self.query_field:
            if not request.query.get(self.query_field, '').startswith(request.app_folder_path):
                raise ForbiddenError()
        return True


class DiskPartnerPermission(DynamicScopesPermission):
    """Доступ к партнёрским ручкам в Диске"""
    def get_required_scopes(self, request):
        required_scopes = [s for s in request.client.scopes if s.startswith('cloud_api:disk.partners.')]
        return required_scopes


class DiskSearchPermission(ClientHasScopesPermission):
    """Доступ на поиск по Диску."""
    scopes = ('cloud_api:disk.search', )


class DiskVideoPublicPermission(AllowAllPermission):
    """Доступ к публичным видео."""


class DiskAttachWritePermission(ClientHasScopesPermission):
    """Доступ к загрузке аттачей в Диск."""
    scopes = ('cloud_api:disk.attach.write', )


class DiskBillingReadPermission(ClientHasScopesPermission):
    """Доступ на чтение данных об услугах пользователя"""
    scopes = ("cloud_api:disk.billing.read",)


class DiskPromoCodesWritePermission(ClientHasScopesPermission):
    """Доступ на запись данных о промокодах"""
    scopes = ("cloud_api:disk.promo_codes.write",)


class DiskBatchPermission(ClientHasScopesPermission):
    """Доступ на выполнение пакетных запросов"""
    scopes = ("cloud_api:disk.batch",)


class MobileMailPermission(ClientHasScopesPermission):
    scopes = ("mobmail:all",)
