# -*- coding: utf-8 -*-
from mpfs.platform import exceptions


class DiskPromoCodeNotFoundError(exceptions.NotFoundError):
    description = 'Promo code not found.'
    message = u'Промокод не найден.'


class DiskPromoNotActiveForThisCodeError(exceptions.NotFoundError):
    description = 'Promo of provided promo code is not active.'
    message = u'Акция данного промокода неактивна.'


class DiskUserAlreadyHasSuchPromoServiceError(exceptions.ConflictError):
    description = 'Can\'t activate promo code because user already has such service.'
    message = u'Невозможно активировать промокод, потому что у пользователя уже есть услуга по данной акции.'


class DiskAttemptToActivateUsedPromoCodeError(exceptions.ConflictError):
    description = 'Can\'t activate promo code because someone already used this promo code.'
    message = u'Невозможно активировать промокод, потому что кто-то уже активировал данный промокод.'
