# -*- coding: utf-8 -*-
"""API работы с промокодами"""
from mpfs.platform.exceptions import TooManyRequestsError
from mpfs.platform.v1.disk.handlers import MpfsProxyHandler
from mpfs.platform.v1.disk.permissions import DiskPromoCodesWritePermission
from mpfs.platform.v1.disk.promo_codes.exceptions import (
    DiskAttemptToActivateUsedPromoCodeError,
    DiskPromoCodeNotFoundError,
    DiskPromoNotActiveForThisCodeError,
    DiskUserAlreadyHasSuchPromoServiceError
)
from mpfs.platform.v1.disk.promo_codes.serializers import (
    PromoCodeActivateBodySerializer,
    PromoCodeActivateResponseSerializer,
)


class PromoCodeActivateHandler(MpfsProxyHandler):
    """Активировать промокод"""
    service_method = 'PUT'
    need_auto_initialize_user = False

    permissions = DiskPromoCodesWritePermission()
    serializer_cls = PromoCodeActivateResponseSerializer
    body_serializer_cls = PromoCodeActivateBodySerializer
    hidden = True
    service_url = '/json/promo_code_activate?uid=%(uid)s&promo_code=%(promo_code)s'

    error_map = {
        228: DiskPromoCodeNotFoundError,
        229: DiskUserAlreadyHasSuchPromoServiceError,
        230: TooManyRequestsError,
        231: DiskAttemptToActivateUsedPromoCodeError,
        232: DiskPromoNotActiveForThisCodeError,
    }

    def get_context(self, context=None):
        c = super(PromoCodeActivateHandler, self).get_context(context)
        request_body = self.request.body
        c['promo_code'] = request_body['promo_code']
        return c
