# -*- coding: utf-8 -*-
from mpfs.platform.fields import (
    SerializerField,
    StringField,
)
from mpfs.platform.serializers import BaseSerializer
from mpfs.platform.v1.disk.billing.serializers import BillingSubscriptionSerializer


class PromoCodeActivateBodySerializer(BaseSerializer):
    """Сериализатор тела пользовательского запроса на активацию промокода"""
    visible_fields = ['promo_code']
    fields = {
        'promo_code': StringField(help_text=u'Промокод.'),
    }


class PromoCodeActivateResponseSerializer(BaseSerializer):
    """Серализатор ответа на активацию промокода"""
    visible_fields = ['subscription']
    fields = {
        'subscription': SerializerField(BillingSubscriptionSerializer, source='billing_service', help_text=u'Выданная по промокоду подписка.')
    }
