# -*- coding: utf-8 -*-
import urlparse
from mpfs.platform.rate_limiters import BaseRateLimiter


class PerUploadExternalHostRateLimiter(BaseRateLimiter):
    """Достаёт из query значение параметра url и лимитирует по хосту этого URL."""
    DEFAULT_HOST = 'undefined'

    def get_counter_key(self, request):
        url = request.query['url']
        url_chunks = urlparse.urlparse(url)
        key = url_chunks.netloc or self.DEFAULT_HOST
        return key
