# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.common import PlatformResponse
from mpfs.platform.fields import QueryDict
from mpfs.platform.v1.disk.fields import MpfsPathField, ResourceIdField
from mpfs.platform.v1.disk.handlers import MpfsProxyHandler
from mpfs.platform.v1.disk.permissions import WebDavPermission
from mpfs.platform.v1.disk.serializers import UploadResourceSerializer
from mpfs.platform.v1.disk.handlers import GetOperationStatusHandler


class BaseRestoreHandler(MpfsProxyHandler):
    pass


class ReportRestoreHandler(BaseRestoreHandler):
    permissions = WebDavPermission()
    kwargs = fields.QueryDict({
        'report_type': fields.StringField(required=True, help_text=u'Тип проблемы'),
    })
    query = QueryDict({
        'path': MpfsPathField(required=True, help_text=u'Путь файла, как в снапшоте.'),
        'resource_id': ResourceIdField(help_text=u'resource_id файла, как указано в снапшоте.'),
        'file_revision': fields.StringField(required=True,
                                            help_text=u'Ревизия в которой файл был изменён, как указано в снапшоте.'),
        'disk_revision': fields.StringField(required=True, help_text=u'Ревизия Диска, как указано в снапшоте.'),
        'local_md5': fields.StringField(help_text=u'Посчитанный ПО MD5 файла.'),
        'local_sha256': fields.StringField(help_text=u'Посчитанный ПО SHA256 файла.'),
        'local_size': fields.IntegerField(help_text=u'Посчитанный ПО размер файла.'),
        'remote_md5': fields.StringField(help_text=u'MD5 файла, полученный из бэкэнда.'),
        'remote_sha256': fields.StringField(help_text=u'SHA256 файла, полученный из бэкэнда.'),
        'remote_size': fields.IntegerField(help_text=u'Размер файла, полученный из бэкэнда.'),
    })

    def handle(self, request, *args, **kwargs):
        return PlatformResponse(204, '{}')


class RestoreUploadHandler(BaseRestoreHandler):
    permissions = WebDavPermission()
    query = QueryDict({
        'md5': fields.StringField(required=True, help_text=u'MD5 файла.'),
        'sha256': fields.StringField(required=True, help_text=u'SHA256 файла.'),
        'size': fields.IntegerField(required=True, help_text=u'Размер файла.'),
    })
    serializer_cls = UploadResourceSerializer
    service_url = '/json/restore_file?uid=%(uid)s&md5=%(md5)s&sha256=%(sha256)s&size=%(size)d'

    def handle(self, request, *args, **kwargs):
        context = super(RestoreUploadHandler, self).get_context()
        service_url = self.build_url(self.service_url, context=context)
        store_response = self.request_service(service_url, method=self.service_method)
        upload_link = ('PUT', store_response.get('upload_url'), False,)
        operation_link = self.router.get_link(GetOperationStatusHandler, {'operation_id': store_response.get('oid')})
        return self.serialize({'upload_link': upload_link, 'operation_link': operation_link})
