# -*- coding: utf-8 -*-
from mpfs.platform import exceptions
from mpfs.platform.exceptions import BadRequestError, ConflictError
from mpfs.platform.v1.disk.exceptions import DiskUserBlockedError, DiskUserNotFoundError
from mpfs.platform.v1.disk.rostelecom.serializers import RostelecomUnableToInitSerializer


class RostelecomUnableToInitializeUserError(exceptions.ForbiddenError):
    error_serializer_cls = RostelecomUnableToInitSerializer
    description = 'Unable to initialize user.'
    message = u'Нельзя инициализировать пользователя.'

    def __init__(self):
        super(RostelecomUnableToInitializeUserError, self).__init__(
            registration_link='https://passport.yandex.ru/profile/upgrade')


class RostelecomUserBlockedError(DiskUserBlockedError):
    status_code = 404


class RostelecomIncorrectServiceKeyError(BadRequestError):
    description = 'Incorrect service_key.'
    message = u'Некорректный идентификатор услуги.'


class RostelecomServiceActiveError(ConflictError):
    description = 'Service is active.'
    message = u'Услуга активна.'


class RostelecomServiceDeactivatedError(ConflictError):
    description = 'Service is deactivated.'
    message = u'Услуга неактивна.'


class RostelecomServiceBlockedError(ConflictError):
    description = 'Service is blocked.'
    message = u'Услуга заблокирована.'


class RostelecomUserDoesNotExistError(DiskUserNotFoundError):
    status_code = 403
